/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1093;
import net.minecraft.class_1100;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_753;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_787;
import net.minecraft.class_789;
import net.minecraft.class_793;
import net.minecraft.class_796;
import net.minecraft.class_806;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.LogicHelper;

public class ColoredBlockModel
implements IUnbakedGeometry<ColoredBlockModel> {
    public static final Loader LOADER = new Loader();
    private final SimpleBlockModel model;
    private final List<ColorData> colorData;

    public List<class_785> getElements() {
        return this.model.getElements();
    }

    public void resolveParents(Function<class_2960, class_1100> modelGetter, class_793 context) {
        this.model.resolveParents(modelGetter, context);
    }

    public static void bakePart(class_1093.class_1094 builder, class_793 owner, class_785 part, int color, int luminosity, class_3665 transform, Function<class_4730, class_1058> spriteGetter, class_2960 location) {
        ColoredBlockModel.bakePart(builder, owner, part, color, luminosity, transform.method_3509(), transform.method_3512(), spriteGetter, location);
    }

    public static void bakePart(class_1093.class_1094 builder, class_793 owner, class_785 part, int color, int luminosity, class_4590 transform, boolean uvlock, Function<class_4730, class_1058> spriteGetter, class_2960 location) {
        for (class_2350 direction : part.field_4230.keySet()) {
            class_783 face = (class_783)part.field_4230.get(direction);
            String texture = face.field_4224;
            if (texture.charAt(0) == '#') {
                texture = texture.substring(1);
            }
            class_1058 sprite = spriteGetter.apply(owner.method_24077(texture));
            class_777 quad = ColoredBlockModel.bakeFace(part, face, sprite, direction, transform, uvlock, color, luminosity, location);
            if (face.field_4225 == null) {
                builder.method_4748(quad);
                continue;
            }
            builder.method_4745(class_2350.method_23225((Matrix4f)transform.method_22936(), (class_2350)face.field_4225), quad);
        }
    }

    public static class_1087 bakeModel(class_793 owner, List<class_785> elements, List<ColorData> colorData, class_3665 transform, class_806 overrides, Function<class_4730, class_1058> spriteGetter, class_2960 location) {
        class_1058 particle = spriteGetter.apply(owner.method_24077("particle"));
        class_1093.class_1094 builder = new class_1093.class_1094(owner.method_3444(), owner.method_24298().method_24299(), true, owner.method_3443(), overrides).method_4747(particle);
        int size = elements.size();
        class_4590 transformation = transform.method_3509();
        boolean uvlock = transform.method_3512();
        for (int i = 0; i < size; ++i) {
            class_785 part = elements.get(i);
            ColorData colors = LogicHelper.getOrDefault(colorData, i, ColorData.DEFAULT);
            ColoredBlockModel.bakePart(builder, owner, part, colors.color, colors.luminosity(), transformation, colors.isUvLock(uvlock), spriteGetter, location);
        }
        return builder.method_4746();
    }

    public class_1087 bake(class_793 owner, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_806 overrides, class_2960 modelLocation, boolean isGui3d) {
        return ColoredBlockModel.bakeModel(owner, this.model.getElements(), this.colorData, modelTransform, overrides, spriteGetter, modelLocation);
    }

    public class_1087 bakeDynamic(class_793 owner, class_3665 transform) {
        return ColoredBlockModel.bakeModel(owner, this.getElements(), this.colorData, transform, class_806.field_4292, class_4730::method_24148, SimpleBlockModel.BAKE_LOCATION);
    }

    public static ColoredBlockModel deserialize(JsonDeserializationContext context, JsonObject json) {
        SimpleBlockModel model = SimpleBlockModel.deserialize(context, json);
        List<ColorData> colorData = json.has("colors") ? JsonHelper.parseList(json, "colors", ColorData::fromJson) : Collections.emptyList();
        return new ColoredBlockModel(model, colorData);
    }

    @Deprecated
    public static class_777 bakeFace(class_785 part, class_783 face, class_1058 sprite, class_2350 facing, class_3665 transform, int color, int luminosity, class_2960 location) {
        return ColoredBlockModel.bakeFace(part, face, sprite, facing, transform.method_3509(), transform.method_3512(), color, luminosity, location);
    }

    public static class_777 bakeFace(class_785 part, class_783 face, class_1058 sprite, class_2350 facing, class_4590 transform, boolean uvlock, int color, int luminosity, class_2960 location) {
        return ColoredBlockModel.bakeQuad(part.field_4228, part.field_4231, face, sprite, facing, transform, uvlock, part.field_4232, part.field_4229, color, luminosity, location);
    }

    @Deprecated
    public static class_777 bakeQuad(Vector3f posFrom, Vector3f posTo, class_783 face, class_1058 sprite, class_2350 facing, class_3665 transform, @Nullable class_789 partRotation, boolean shade, int color, int luminosity, class_2960 location) {
        return ColoredBlockModel.bakeQuad(posFrom, posTo, face, sprite, facing, transform.method_3509(), transform.method_3512(), partRotation, shade, color, luminosity, location);
    }

    public static class_777 bakeQuad(Vector3f posFrom, Vector3f posTo, class_783 face, class_1058 sprite, class_2350 facing, class_4590 transform, boolean uvlock, @Nullable class_789 partRotation, boolean shade, int color, int luminosity, class_2960 location) {
        class_787 faceUV = face.field_4227;
        if (uvlock) {
            faceUV = class_796.method_3454((class_787)face.field_4227, (class_2350)facing, (class_4590)transform, (class_2960)location);
        }
        float[] originalUV = new float[faceUV.field_4235.length];
        System.arraycopy(faceUV.field_4235, 0, originalUV, 0, originalUV.length);
        float shrinkRatio = sprite.method_23842();
        float u = (faceUV.field_4235[0] + faceUV.field_4235[0] + faceUV.field_4235[2] + faceUV.field_4235[2]) / 4.0f;
        float v = (faceUV.field_4235[1] + faceUV.field_4235[1] + faceUV.field_4235[3] + faceUV.field_4235[3]) / 4.0f;
        faceUV.field_4235[0] = class_3532.method_16439((float)shrinkRatio, (float)faceUV.field_4235[0], (float)u);
        faceUV.field_4235[2] = class_3532.method_16439((float)shrinkRatio, (float)faceUV.field_4235[2], (float)u);
        faceUV.field_4235[1] = class_3532.method_16439((float)shrinkRatio, (float)faceUV.field_4235[1], (float)v);
        faceUV.field_4235[3] = class_3532.method_16439((float)shrinkRatio, (float)faceUV.field_4235[3], (float)v);
        int[] vertexData = ColoredBlockModel.makeVertices(faceUV, sprite, facing, class_793.field_4249.method_3459(posFrom, posTo), transform, partRotation, color, luminosity);
        class_2350 direction = class_796.method_3467((int[])vertexData);
        System.arraycopy(originalUV, 0, faceUV.field_4235, 0, originalUV.length);
        if (partRotation == null) {
            class_793.field_4249.method_3462(vertexData, direction);
        }
        ColoredBlockModel.fillNormal(vertexData, direction);
        return new class_777(vertexData, face.field_4226, direction, sprite, shade);
    }

    private static Vector3f getVertexPos(int[] data, int vertex) {
        int idx = vertex * 8;
        float x = Float.intBitsToFloat(data[idx]);
        float y = Float.intBitsToFloat(data[idx + 1]);
        float z = Float.intBitsToFloat(data[idx + 2]);
        return new Vector3f(x, y, z);
    }

    public static void fillNormal(int[] faceData, class_2350 facing) {
        Vector3f v1 = ColoredBlockModel.getVertexPos(faceData, 3);
        Vector3f t1 = ColoredBlockModel.getVertexPos(faceData, 1);
        Vector3f v2 = ColoredBlockModel.getVertexPos(faceData, 2);
        Vector3f t2 = ColoredBlockModel.getVertexPos(faceData, 0);
        v1.sub((Vector3fc)t1);
        v2.sub((Vector3fc)t2);
        v2.cross((Vector3fc)v1);
        v2.normalize();
        int x = (byte)Math.round(v2.x() * 127.0f) & 0xFF;
        int y = (byte)Math.round(v2.y() * 127.0f) & 0xFF;
        int z = (byte)Math.round(v2.z() * 127.0f) & 0xFF;
        int normal = x | y << 8 | z << 16;
        for (int i = 0; i < 4; ++i) {
            faceData[i * 8 + 7] = normal;
        }
    }

    private static int[] makeVertices(class_787 uvs, class_1058 sprite, class_2350 orientation, float[] posDiv16, class_4590 rotationIn, @Nullable class_789 partRotation, int color, int luminosity) {
        int[] vertexData = new int[32];
        for (int i = 0; i < 4; ++i) {
            ColoredBlockModel.bakeVertex(vertexData, i, orientation, uvs, posDiv16, sprite, rotationIn, partRotation, color, luminosity);
        }
        return vertexData;
    }

    private static void bakeVertex(int[] vertexData, int vertexIndex, class_2350 facing, class_787 blockFaceUVIn, float[] posDiv16, class_1058 sprite, class_4590 rotationIn, @Nullable class_789 partRotation, int color, int luminosity) {
        class_753.class_755 vertexInfo = class_753.method_3163((class_2350)facing).method_3162(vertexIndex);
        Vector3f vector3f = new Vector3f(posDiv16[vertexInfo.field_3975], posDiv16[vertexInfo.field_3974], posDiv16[vertexInfo.field_3973]);
        class_793.field_4249.method_3463(vector3f, partRotation);
        class_793.field_4249.method_3455(vector3f, rotationIn);
        ColoredBlockModel.fillVertex(vertexData, vertexIndex, vector3f, sprite, blockFaceUVIn, color, luminosity);
    }

    private static int swapColorRedBlue(int color) {
        return color & 0xFF00FF00 | color >> 16 & 0xFF | color << 16 & 0xFF0000;
    }

    private static void fillVertex(int[] vertexData, int vertexIndex, Vector3f vector, class_1058 sprite, class_787 blockFaceUV, int color, int luminosity) {
        int i = vertexIndex * 8;
        vertexData[i] = Float.floatToRawIntBits(vector.x());
        vertexData[i + 1] = Float.floatToRawIntBits(vector.y());
        vertexData[i + 2] = Float.floatToRawIntBits(vector.z());
        vertexData[i + 3] = ColoredBlockModel.swapColorRedBlue(color);
        vertexData[i + 4] = Float.floatToRawIntBits(sprite.method_4580((double)blockFaceUV.method_3415(vertexIndex) * 0.999 + (double)blockFaceUV.method_3415((vertexIndex + 2) % 4) * 0.001));
        vertexData[i + 5] = Float.floatToRawIntBits(sprite.method_4570((double)blockFaceUV.method_3416(vertexIndex) * 0.999 + (double)blockFaceUV.method_3416((vertexIndex + 2) % 4) * 0.001));
        vertexData[i + 6] = luminosity << 4;
    }

    public ColoredBlockModel(SimpleBlockModel model, List<ColorData> colorData) {
        this.model = model;
        this.colorData = colorData;
    }

    public SimpleBlockModel getModel() {
        return this.model;
    }

    public List<ColorData> getColorData() {
        return this.colorData;
    }

    public record ColorData(int color, int luminosity, @Nullable Boolean uvlock) {
        public static final ColorData DEFAULT = new ColorData(-1, 0, null);

        @Deprecated
        public ColorData(int color, int luminosity) {
            this(color, luminosity, null);
        }

        public boolean isUvLock(boolean defaultLock) {
            if (this.uvlock == null) {
                return defaultLock;
            }
            return this.uvlock;
        }

        public static ColorData fromJson(JsonObject json) {
            int color = JsonHelper.parseColor(class_3518.method_15253((JsonObject)json, (String)"color", (String)""));
            int luminosity = class_3518.method_15282((JsonObject)json, (String)"luminosity", (int)0);
            Boolean uvlock = null;
            if (json.has("uvlock")) {
                uvlock = class_3518.method_15270((JsonObject)json, (String)"uvlock");
            }
            return new ColorData(color, luminosity, uvlock);
        }
    }

    private static class Loader
    implements IGeometryLoader<ColoredBlockModel> {
        private Loader() {
        }

        public ColoredBlockModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            return ColoredBlockModel.deserialize(deserializationContext, modelContents);
        }
    }
}

